%
% Automatisierung: Kapitel 7
% Zur Erreichbarkeit und Beobachtbarkeit in Matlab
% Fr weitere Details konsultieren Sie bitte die help-Funktion von Matlab

%% Beispiel Gleichung (7.6) 
close all;
clear all;

% System
Ac = [-2,1,0;-1,-2,0;1,1,1];
bc = [-1,2,1]';
cc = [1,0,1];
dc = 0;
sysc = ss(Ac,bc,cc,dc);

%bertragungsfunktion des zeitkontinuierlichen Systems
Gs=tf(sysc);

%Erreichbarkeitsmatrix
Rc = ctrb(sysc);
%berprfung auf vollstndige Erreichbarkeit
rank_Rc = rank(Rc);

disp(['Rang der kont. Erreichbarkeitsmatrix Rc: ',num2str(rank_Rc)]);

%% Zeitdiskretes System
%Abtastzeit Ta 
Ta = pi;

%Abtastmodell
sysd = c2d(sysc,Ta,'zoh');

%bertragungsfunktion des Abtastmodells
Gz = c2d(Gs,Ta,'zoh');

%Berechnen der Pol- und Nullstellen von Gz
pp = pole(Gz);
zz = zero(Gz);

%Durchfhren der Pol/Nullstellenkrzung mit Hilfe des Befehls minreal
Gz_g = minreal(Gz,1e-6);

%Erreichbarkeitsmatrix
Rd = ctrb(sysd);

%berprfung auf vollstndige Erreichbarkeit
rank_Rd =rank(Rd);

disp(['Rang der disk. Erreichbarkeitsmatrix Rd: ',num2str(rank_Rd)]);

%% Erzeugung eines greren nichterreichbaren Systems
N = 20;
kk = 1:N;
AA = diag(-kk'.*ones(N,1));
bb = ones(N,1);
cc = ones(N,1)';
dd = 0;

for j=ceil(N/4):1:ceil(N/2)
    bb(j) = 0;
end;

sysc = ss(AA,bb,cc,dd);

ll = length(ceil(N/4):1:ceil(N/2));

%Dimension der Erreichbarkeitsmatrix msste laut Theorie N-ll sein
rank_theorie = N-ll;
disp(['Rang nach Theorie: ',num2str(rank_theorie)]);

%Erreichbarkeitsprfung mit der Erreichbarkeitsmatrix
RR = ctrb(AA,bb);
rank_ctrb = rank(RR);
disp(['Rang der Erreichbarkeitsmatrix: ',num2str(rank_ctrb)]);

%Erreichbarkeitsprfung mit Gramscher Matrix
WC = gram(sysc,'cf');
rank_gram =rank(WC);
disp(['Rang mit Hilfe der Gramschen Matrix: ',num2str(rank_gram)]);

%Erreichbarkeitsprfung ber einen Iterationsalgorithmus von Matlab
[A_B,b_B,c_B,T,K] = ctrbf(AA,bb,cc,1e-7);
rank_ctrbf = sum(K);
disp(['Rang ber Iterationsalgorithmus von Matlab: ',num2str(rank_ctrbf)]);

%% Aufspaltung in ein vollstndig erreichbares und ein nicht erreichbares
%  Teilsystem
Phi = [-7,-18,-42;4,11,28;0,0,-2];
Gamma = [8,-14/3,1]';
c = [0,0,1];

%Erreichbarkeitsprfung mit der Erreichbarkeitsmatrix
R = ctrb(Phi,Gamma);
rank_ctrb = rank(R);
disp(['Rang der Erreichbarkeitmatrix: ',num2str(rank_ctrb)]);

%Aufspaltung in ein vollstndig erreichbares und ein nicht erreichbares
%Teilsystem
[Phi_B,Gamma_B,c_B,T,K] = ctrbf(Phi,Gamma,c)
%Anzahl der erreichbaren Zustnde
rank_ctrbf = sum(K)