%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Einf�hrung in Matlab/Simulink
% 
% Bakk.-Vertiefung
% Institut fuer Automatisierungstechnik 
% Gruppe fuer komplexe dynamische Systeme
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Aufraeumen
clear
close all 
clc

%% Parameter deffinieren
T = 0.5;
xi = 0.2;
V = 2;
Ta = 0.1;

%% Moeglichkeiten zum Implementieren eines Systems, PT2-Glied

% 1. Moeglichkeit: Uebertragungsfunktion

G_tf = tf([V],[T^2 2*xi*T 1])

G_z  = c2d(G_tf,Ta,'zoh')

% 2. Moeglichkeit: Zustandsraumdarstellung

A = [0 1; -1/T^2 -2*xi/T];
B = [0;V/T^2];
C = [1;0];
D = 0;

sys = ss(A,B,C',D)