%% Parameterfiles fuer das Simulink Modell des elektrischen Systems.

% Widerstaende R1 und R2
R_1 = 600;    % Widerstand in Ohm
R_2 = 3500;   % Widerstand in Ohm

% Widerstandsverhaeltnis R4
K = 3;        % Spannungsverstrkung

% Kapazitaeten C1 und C2
C1_ref  = 9e-6;   % Referenz-Kapazittswert auf Kennlinie von C1 in F
C1_inf  = 1e-9;   % Referenz-Kapazittswert auf Kennlinie von C1 in F
UC1_ref = 3.5;      % Referenz-Spannungswert auf Kennlinie von C1 in V
C2      = 1e-6;   % Kapazitt in F

% Festlegung der Ruhelage
UeR = 5;
UsR = 5;

%% Eingangsspannung und Stoerspannung
% Sprungfoermige Eingangsspannung
te = .05;      % Einschaltzeitpunkt
Ue = 7;      % Endwert des Sprunges

% Sinusfoermige Eingangsspannung
Usinus = 1;    % Amplitude des Sinus    
we     = 1000; % Winkelfrequenz des Sinus   

% Rechteckfoermige Stoerspannung
ts1 = 0.03;     % Einschaltzeitpunkt   
ts2 = 0.11;     % Auschaltzeitpunkt  
Us = 4;      % Endwert des Sprunges

% Rampenfrmige Strspannung
tsr1 = 0.05;    % Einschaltzeitpunkt
tsr2 = 0.10;  % Auschaltzeitpunkt  
dr = -10;      % Steigung


%% Modell des linearisierten Systems

% Aufgabe 1.4.4
% -------------
% Errechnen Sie die Ruhelage des Systems!
% UC1R = ;
% UC2R = ;
% UaR  = ;

% Errechnen Sie fr die gegebene Ruhelage die Ableitungen der in C1 
% gespeicherter Ladung Q1 nach der anliegenden Spannung!
% dQ1  = ; % Erste Ableitung von Q1 nach UC1
% ddQ1 = ; % Zweite Ableitung von Q1 nach UC1

% Ergaenzen Sie die Systemmatrix A (Asys), die Eingangsvektoren bu (busys)
% und bd (bdsys) sowie den Ausgangsvektor c (csys) und den Durchgriff d (dsys)
% fr das linearisierte System!

% A11 = ;
% A12 = ;
% A21 = ;
% A22 = ;

% Asys  = [A11,A12;A21,A22];
% busys = [];
% bdsys = [];
% csys  = [];
% dusys = [];
% ddsys = [];

%% Save Parameters
par.R1      = R_1;
par.R2      = R_2;
par.K       = K;
par.C1_ref  = C1_ref;
par.C1_inf  = C1_inf;
par.UC1_ref = UC1_ref;
par.C2      = C2;

par.x0 = [UC1R;UC2R];

