function [parKompReg, KompReg] = fct_Kompensationsregler(sysGSM, tr, ue, Ta, real_pole, show_plots)
  arguments
      sysGSM struct
      tr double
      ue double
      Ta double
      real_pole (2, 1) {mustBeNumeric, mustBeReal}
      show_plots {mustBeNumericOrLogical} = false
  end

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % Berechnung des Kompensationsreglers-Reglers für die GSM
  % Übung 2: Reglerentwurf und Simulation
  % 
  % Achtung: GSM_Parameter muss geladen werden!
  %
  % INPUT: 
  %   sysGSM - Struktur mit Systemmatrizen und Übertragungsfunktionen
  %   tr - geforderte Anstiegszeit
  %   ue - gefordertes maximales Überschwingen
  %   Ta - Abtastzeit
  %   real_pole - Realisierungspole für den Kompensationsterm
  %   show_plots - flag ob Plots erstellt werden sollen
  %
  % OUTPUT:
  %   parKompReg - Struktur mit Kompensationsregler Parameter
  %   KompReg - z Übertragungsfunktion des entworfenen Komp. Reglers
  %
  % =======================================================================
  % LU Regelugnstechnik: GSM mit Propeller
  % Ersteller:    Florian Beck, 15.11.2022
  % Änderungen:   Martin Baumann, 08.11.2023
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

  s = tf('s');

  % TODO
  
  if(show_plots)
    figure; clf; hold all;
    set(gcf,'name','Zeitdiskreter FKL Entwurf für Kompensationsregler','numbertitle','off')
    % TODO Bode plots

    figure; clf;

    %Sprunghöhe für Stellgrößenbeschränkung
    OmegaStep = 20;         %rad/s
  
    set(gcf,'name','Sprungantwort des Systems mit Kompensationsregler, zeitdiskret','numbertitle','off')
    
    % TODO Sprungantwort plots
  end

  parKompReg.Ta = ;
  parKompReg.VP = ;
  parKompReg.VI = ;
  parKompReg.Rkompz = ; % z-Übertragungsfunktion des Kompensationsteils
  KompReg = ; % Gesamter Kompensationsregler
end