function [parGSM, sysGSM] = fct_Parameter_GSM(uGSM_R, M_ext)
  arguments
      uGSM_R (1, 1) double
      M_ext (1, 1) double
  end

  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  % Bestimmen der Parameterstrukturen für die GSM
  % Übung 2: Reglerentwurf und Simulation
  %
  % INPUT: 
  %   uGSM_R - numerischer Wert für die Ruhelage uGSM
  %   M_ext - externes Stördrehmoment
  %
  % OUTPUT:
  %   parGSM - Parameterstruktur mit den GSM Parametern
  %   sysGSM - Sturktur mit den Parametern für die State-Space-Blöcke
  %
  % =======================================================================
  % LU Regelugnstechnik: GSM mit Propeller
  % Ersteller:    Florian Beck, 15.11.2022
  % Änderungen:   
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


  % Parameter der GSM und des Lastmodells (Parameter des Systems)
  % entsprechend der Angabe Skriptum (z.B. entspricht JGSM der Summe von
  % JBL+JGSM)
  % (vgl. Angabe und Maple-Datei)
  parGSM.L_GSM = 1.4e-3;  %Induktivität Anker GSM in [H]
  parGSM.R_GSM = 0.46;    %Widerstand Anker GSM   in [Ohm]
  parGSM.k_GSM = 0.1;     %Motorkonstante GSM     in [Nm/A]
  parGSM.J_GSM = 12.4e-3; %eff. Trägheitsmoment GSM in [kgm²]
  parGSM.dv_GSM = 1.8e-3; %Viskose Dämpfung GSM in [Nms/rad]
  parGSM.dc_GSM = 0.152 ; %Coulombsche Dämpfung GSM in [Nm]
  parGSM.J_P = 32.5e-3;   %Trägheitsmoment Propeller in [kgm²]
  parGSM.c_GSMP = 0.6822; %Federkonstante der Drehfeder F4 mit 211mm Innen-Innnen Vorspannung in [Nm/rad]
  parGSM.d_GSMP = 1e-5;   %Viskose Dämpfung Kopplung GSM-Propeller in [Nms/rad]
  parGSM.dc_P = 0.169;    %Coulombsche Dämpfung GSM in [Nm]
  parGSM.dv_P = 2.7e-3;   %Viskose Dämpfung Propeller in [Nms/rad]
  parGSM.dq_P = 1e-4;     %quadratische Dämpfung Propeller in [Nms²/rad²]
  parGSM.u_min = 0;       %minimale Spannung 
  parGSM.u_max = 12;      %maximale Spannung 

  % Ruhelagen des Systems
  parGSM.uGSM_R = ;       
  parGSM.Mext_R = M_ext;
  
  parGSM.omegaP_R = ;
           
  %Stationäre Betrachtung
  parGSM.omegaGSM_R = ;           
  parGSM.iGSM_R = ; 
  parGSM.phiGSMP_R = ;

  % Linearisiertes vollständiges System
  sysGSM.A = ;
  sysGSM.B = ;
  sysGSM.C = ;
  sysGSM.D = ; 
  
  % Führungsübertragungsfunktion
  sysGSM.SS_uP = ss();        %Zustandsraumdarstellung uGSM->omegaP
  sysGSM.Gs_uP = tf();        %zugehörige Übertragungsfunktion
  
  % Reduziertes linearisiertes Modell (ohne Stromdynamik)
  sysGSM.Ared = ;
  sysGSM.Bred = ;
  sysGSM.Cred = ;
  sysGSM.Dred = ;
  
  % Führungsübertragungsfunktionen des reduzierten Systems
  sysGSM.SS_uPred = ss();        %Zustandsraumdarstellung uGSM->omegaP
  sysGSM.Gs_uPred = tf();        %zugehörige Übertragungsfunktion
end

